// ParamApplet.java

import java.awt.*;
import javax.swing.*;

public class ParamApplet extends JApplet {
    private Font f = new Font("Serif", Font.BOLD + Font.ITALIC, 36);
    private String s;
    public void init() {
        if ((s = getParameter("text")) == null)
            s = "OOP in Java";           
        JLabel l = new JLabel(s, JLabel.CENTER);
        l.setBackground(Color.blue);
        String r = getParameter("rot"), g = getParameter("gruen"), 
            b = getParameter("blau");
        Color c = Color.yellow;
        if (r != null && g != null && b != null)
            c = new Color(Integer.parseInt(r), Integer.parseInt(g), 
			  Integer.parseInt(b)); 
        l.setForeground(c);
        l.setFont(f);
        l.setOpaque(true);
        getContentPane().add(l);
    }
    public String getAppletInfo() {
        return "Das Applet zeigt lediglich einen Text an.";
    }
    public String[][] getParameterInfo() {
        return new String[][] {
            { "text", "String", "Text, der angezeigt werden soll" },
            { "rot", "int (0-255)", "Rot-Anteil der Vordergrundfarbe" },
            { "gruen", "int (0-255)", "Grn-Anteil der Vordergrundfarbe" },
            { "blau", "int (0-255)", "Blau-Anteil der Vordergrundfarbe" }
        }; 
    }
}
