// PositionsTest.java

import java.awt.*;
import javax.swing.*;

class PositionsTest extends JPanel {
    PositionsTest() {
        setBackground(Color.white);
        Icon ic = new ImageIcon(
                    PositionsTest.class.getResource("icons/world1.gif"));
        setLayout(new GridLayout(3, 3));
        int[] hpos = { JLabel.LEFT, JLabel.CENTER, JLabel.RIGHT },
            vpos = { JLabel.TOP, JLabel.CENTER, JLabel.BOTTOM };
        for (int h = 0; h < hpos.length; h++)
            for (int v = 0; v < vpos.length; v++) {
                JLabel lab = new JLabel("Text", ic, JLabel.CENTER);
                lab.setHorizontalTextPosition(hpos[h]);
                lab.setVerticalTextPosition(vpos[v]);
                add(lab);
            }
    }
    public static void main(String[] args) {
        JFrame f = new JFrame("Positions-Test");
        f.getContentPane().add(new PositionsTest());
        f.setSize(300, 300);
	f.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        f.setVisible(true);
    }
}
