// PunktePanel.java

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

class PunktePanel extends JPanel {
    private static final int MAX_ANZ = 1000;
    private int anz = 0;
    private int[][] punkte = new int[MAX_ANZ][2];
    PunktePanel() {
        setBackground(Color.yellow);
        setForeground(Color.green);
        addMouseListener(new MouseAdapter() {
            public void mousePressed(MouseEvent e) {
                if (anz < MAX_ANZ) {
                    punkte[anz][0] = e.getX();
                    punkte[anz++][1] = e.getY();
                    repaint();
                }
            }
        });
    }
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        for (int i = 0; i < anz; i++) 
            g.fillOval(punkte[i][0] - 5, punkte[i][1] - 5, 10, 10);
    }
    public static void main(String[] args) {
        JFrame f = new JFrame("Punkte-Panel");
        f.getContentPane().add(new PunktePanel());
        f.setSize(400, 300);
	f.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        f.setVisible(true);
    }
}
