// RadioTest.java

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

class RadioTest extends JPanel {
    RadioTest() {
        final JRadioButton[] r =  { 
            new JRadioButton("Sun"),
            new JRadioButton("Mac"),
            new JRadioButton("Intel")
        };
        final JTextField sel = new JTextField(10);
        ButtonGroup bg = new ButtonGroup();
        setLayout(new GridLayout(r.length + 2, 1));
        add(new JLabel(" Eine Plattform auswhlen "));
        ItemListener lis = new ItemListener() {
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == ItemEvent.SELECTED)
                    for (int i = 0; i < r.length; i++)
                        if (r[i].isSelected())
                            sel.setText(r[i].getText() + " selektiert");
            }
        };
        for (int i = 0; i < r.length; i++) {
            r[i].addItemListener(lis);
            add(r[i]);
            bg.add(r[i]);
        }
        add(sel);
    }
    public static void main(String[] args) {
        JFrame f = new JFrame("Radio-Test");
        f.getContentPane().add(new RadioTest());
        f.pack();
	f.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        f.setVisible(true);
    }
}
