// RevalidateTest.java

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

class RevalidateTest extends JPanel {
    private int maxAnz = 10, anz = 0;
    private JButton[] but = new JButton[maxAnz];
    RevalidateTest() {
        setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
        setPreferredSize(new Dimension(300, 300));
    }
    void neuerEintrag(String eintrag) {
        if (anz < maxAnz) {
            but[anz] = new JButton(eintrag);
            add(but[anz++]);
            revalidate(); 
            repaint();
        }
    }
    void loescheEintrag(String eintrag) {
        for (int i = 0; i < anz; i++)
            if (eintrag.equals(but[i].getText())) {
                remove(but[i]);
                revalidate(); 
                repaint();
                for (int j = i; j < anz - 1; j++)
                    but[j] = but[j + 1];
                --anz;
                break;
            }
    }
    static class ControlPanel extends JPanel {
        ControlPanel(final RevalidateTest cont) {
            add(new JLabel("Eintrag: "));
            final JTextField eintrag = new JTextField(20);
            final JButton neu = new JButton("neu"), 
                loeschen = new JButton("lschen");
            ActionListener listener = new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == neu)
                        cont.neuerEintrag(eintrag.getText());
                    else
                        cont.loescheEintrag(eintrag.getText());
                }
            };
            neu.addActionListener(listener); 
            loeschen.addActionListener(listener);
            add(eintrag);
            add(neu); 
            add(loeschen);
        }
    }
    public static void main(String[] args) {
        JFrame f = new JFrame("Revalidate-Test");
        RevalidateTest testCont = new RevalidateTest();
        f.getContentPane().add(testCont);
        f.getContentPane().add(new ControlPanel(testCont), BorderLayout.NORTH);
        f.pack();
	f.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        f.setVisible(true);
    }
}
