// TextAreaTest.java

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

class TextAreaTest extends JPanel {
    TextAreaTest() {
        setLayout(new GridLayout(3, 1));
        final JTextArea text1 = new JTextArea(5, 30),
            text2 = new JTextArea(5, 30);
        text1.setLineWrap(true);
        text2.setLineWrap(true);
        JPanel p = new JPanel();
        JButton cut = erzeugeButton(p, "cut.gif", "Cut"),
            copy = erzeugeButton(p, "copy.gif", "Copy"), 
	    paste = erzeugeButton(p, "paste.gif", "Paste");
        add(text1);
        add(p);
        add(text2);
        cut.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                text1.cut();
            }
        });
        copy.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                text1.copy();
            }
        });
        paste.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                text2.paste();
            }
        });
    }
    protected JButton erzeugeButton(JComponent c, String icon, String tip) {
	JButton but = new JButton(new ImageIcon(
                              TextAreaTest.class.getResource("icons/" + icon)));
	but.setToolTipText(tip);
	c.add(but);
	return but;
    }
    public static void main(String[] args) {
        JFrame f = new JFrame("TextArea-Test");
        f.getContentPane().add(new TextAreaTest());
        f.pack();
	f.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        f.setVisible(true);
    }
}
