// Viewer.java

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

class Viewer extends JPanel {
    private JDesktopPane desk;
    Viewer() {
        setLayout(new BorderLayout());
        Box sel = Box.createHorizontalBox();
        JButton[] but = { 
            new JButton("LayoutTest"), 
            new JButton("RadioTest")
        };
        ActionListener lis = new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                String str = e.getActionCommand();
                JPanel pan;
                if (str.equals("LayoutTest"))
                    pan = new LayoutTest();
                else
                    pan = new RadioTest();
                JInternalFrame fr = new JInternalFrame(str, true, true, true, true);
                fr.getContentPane().add(pan);
                fr.pack();
                fr.setVisible(true);
                desk.add(fr);
            }
        };
        for (int i = 0; i < but.length; i++) {
            sel.add(but[i]); 
            but[i].addActionListener(lis);
        }
        add(sel, BorderLayout.NORTH);
        desk = new JDesktopPane();
        add(desk);
    }
    public static void main(String[] args) {
        JFrame f = new JFrame("Viewer");
        f.getContentPane().add(new Viewer());
        f.setSize(500, 400);
	f.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        f.setVisible(true);
    }
}
