// Padding.java

import java.text.*;

class Padding {
    static FieldPosition fpos = new FieldPosition(NumberFormat.INTEGER_FIELD);
    static String pad(double x, DecimalFormat f, int vor) {
        StringBuffer buf = new StringBuffer();
	/* 
	   Die berladene Methode format(double, StringBuffer, FieldPosition) liefert
	   im letzten Argument die Indices des angegebenen Feldes in der formatierten 
	   Zeichenkette, hier also des ganzzahligen Teils zurck (zur ansonsten seltener
	   bentigten Klasse FieldPosition siehe die API-Dokumentation). 
	*/
        f.format(x, buf, fpos);
        int anzSp = vor - (fpos.getEndIndex() - fpos.getBeginIndex());
        if (x < 0)
            anzSp--;
	for ( ; anzSp > 0; anzSp--) 
	    buf.insert(0, ' ');
	return buf.toString();
    }
    public static void main(String[] args) {
        double[] x = { +1.23, 1234.236, -456.67617, 0.0123, -123456789.5 };
	DecimalFormat f = new DecimalFormat("0.00000");
        for (int i = 0; i < x.length; i++)     
            System.out.println("Wert: " + pad(x[i], f, 7));
    }
}
