// OverlayTest.java

import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;

class OverlayTest extends JComponent {
    OverlayTest(String[] namen, final JList list) {
        setLayout(new OverlayLayout(this));
        final JLabel[] icons = new JLabel[namen.length];
        for (int i = 0; i < icons.length; i++) {
            icons[i] = new JLabel(new ImageIcon(
                         OverlayTest.class.getResource("icons/" + namen[i])));
            icons[i].setOpaque(false);
            icons[i].setVisible(false);
            add(icons[i]);
        }
        list.addListSelectionListener(new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e) {
                for (int i = 0; i < icons.length; i++)
                    icons[i].setVisible(list.isSelectedIndex(i)); 
            }
        });
    }
    public static void main(String[] args) {
        String[] n = {
            "bluerose.gif", "redballs.gif", "greenribbon.gif"
        };
        final JList l = new JList(n);
        JFrame f = new JFrame("Overlay-Test");
        Container c = f.getContentPane();
        c.add(l, BorderLayout.WEST);
        c.add(new OverlayTest(n, l), BorderLayout.CENTER);
        f.pack();
	f.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        f.setVisible(true);
    }
}
