// ByteVertauscher.java

import java.io.*;

class ByteVertauscher {
    public static void main(String[] args) {
	if (args.length < 1) {
	    System.out.println("Aufruf mittels java ByteVertauscher <Dateiname>");
	    return;
	}
	try {
	    File f = new File(args[0]).getCanonicalFile();
	    if (! f.exists() || ! f.isFile() || ! f.canRead() || ! f.canWrite()) {
		System.out.println("Das kann ich nicht vertauschen.");
		return;
	    }
	    RandomAccessFile file = new RandomAccessFile(f, "rw");
	    int ch1, ch2;
	    while ((ch1 = file.read()) != -1 && (ch2 = file.read()) != -1) {
		file.seek(file.getFilePointer() - 2);
		file.write((char)ch2);
		file.write((char)ch1);
	    }
	    file.close();
	} catch (IOException ex) {
	    System.out.println("Beim Vertauschen ist ein Fehler aufgetreten.");
	    ex.printStackTrace();
	}
    }
}
