// DateiPruefsumme.java

import java.io.*;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

class DateiPruefsumme {
    public static void main(String[] args) {
	if (args.length < 1) {
	    System.out.println("Aufruf mittels java DateiPruefsumme <Datei>");
	    return;
	}
	long laengeTotal = 0;
	Pruefsumme pruefsumme = new Pruefsumme();
	try {
	    File f = new File(args[0]).getCanonicalFile();
	    FileChannel in = new FileInputStream(f).getChannel();
	    ByteBuffer buf = ByteBuffer.allocateDirect(1000);
	    int laenge;
	    while ((laenge = in.read(buf)) != -1) {
		buf.flip();
		pruefsumme.aktualisiere(buf);
		laengeTotal += laenge;
		buf.clear();
	    }
	} catch (IOException ex) {
	    System.out.println("Ausnahme beim Lesen von " + args[0]
			       + " aufgetreten.");
	    ex.printStackTrace();
	}
	System.out.println("Anzahl Bytes: " + laengeTotal
			   + ", Prfsumme: " + pruefsumme.pruefsumme);
    }
}
