// DatenSchreiber.java

import java.io.*;
import java.nio.*;
import java.nio.channels.FileChannel;
import java.util.Random;

class DatenSchreiber {
    protected static int FLOAT_TYPGROESSE = 4;
    public static void main(String[] args) {
	if (args.length < 1) {
	    System.out.println("Aufruf mittels java DatenSchreiber <anzahl> "
			       + "<Mittelwert> <Standardabweichung> <Datei>");
	    return;
	}
	long anzahl = Long.parseLong(args[0]);
	double mittelwert = Double.parseDouble(args[1]),
	    std = Double.parseDouble(args[2]);
	Random random = new Random();
	try {
	    File f = new File(args[3]).getCanonicalFile();
	    FileChannel out = new FileOutputStream(f).getChannel();
	    ByteBuffer buf = ByteBuffer.allocateDirect(10000);
	    FloatBuffer bufFloat = buf.asFloatBuffer();
	    int puffergroesse = bufFloat.capacity();
	    float[] bufFeld = new float[puffergroesse];
	    int durchlaeufe = (int) Math.ceil(anzahl * 1.0 / puffergroesse);

	    for (int i = 0; i < durchlaeufe; i++) {
		int pufferlaenge = (i+1 < durchlaeufe? puffergroesse
				    : (int) (anzahl - i*puffergroesse));
		for (int j = 0; j < pufferlaenge; j++)
		    bufFeld[j] = (float) (mittelwert + random.nextGaussian() * std);
		bufFloat.put(bufFeld);
		buf.limit(pufferlaenge * FLOAT_TYPGROESSE);
		while (buf.hasRemaining())
		    out.write(buf);
		buf.clear();
		bufFloat.clear();
	    }
	    out.close();
	} catch (IOException ex) {
	    System.out.println("Beim Schreiben ist ein Fehler aufgetreten.");
	    ex.printStackTrace();
	}
    }
}
