// Euklid.java

import java.io.*;
import java.util.logging.*;

class Euklid {
    protected static File logfile = new File(System.getProperty("java.io.tmpdir"), 
					     "euklid.log");
    protected static Logger lg = Logger.getLogger("euklid");
    static {
	lg.setUseParentHandlers(false);
	try {
	    lg.addHandler(new FileHandler(logfile.toString()));
	} catch (IOException ex) {
	    Logger.getLogger("").log(Level.SEVERE, 
                                "Fehler beim ffnen des Logfiles " + logfile, ex);
	}
	lg.setLevel(Level.parse(System.getProperty("euklid.log.level", "INFO")));
    }
    public static long ggt(long a, long b) {
	lg.log(Level.INFO, "Beginn der ggt-Berechnung fr {0} und {1}", 
	       new Long[] { new Long(a), new Long(b) });
	long rest; 
	do {
	    rest = a % b;
	    a = b;
	    b = rest;
	    lg.log(Level.FINE, "a = {0}, b = {1}", 
		   new Long[] { new Long(a), new Long(b) });
	} while (rest != 0);
	lg.log(Level.INFO, "Ende der ggt-Berechnung mit Ergebnis {0}", 
	       new Long(a));
	return a;
    }
    public static void main(String[] args) {
	System.out.println("Der ggt von 47636 und 27458 ist "
			   + ggt(47636, 27458));
    }
}
