// FileMapBeobachter.java

import java.io.*;
import java.nio.*;
import java.nio.channels.*;

class FileMapBeobachter {
    public static void main(String[] args) throws IOException {
	if (args.length < 1) {
	    System.out.println("Aufruf mittels java FileMapBeobachter [Datei]");
	    return;
	}
	File f = new File(args[0]).getCanonicalFile();
	FileChannel in = new FileInputStream(f).getChannel();
	long pos = 0, len = f.length();
	MappedByteBuffer buf = in.map(FileChannel.MapMode.READ_ONLY, pos, len);
	while (true) {
	    System.out.println("1. Byte: " + buf.get(0));
	    // Die folgenden 3 Zeilen bewirken eine kurze Pause von 1 Sekunde (siehe Kap. 17):
	    try {
		Thread.currentThread().sleep(1000);
	    } catch (InterruptedException ex) {} // ignoriere.
	    
	}

    }
}
