// FileMapSchreiber.java

import java.io.*;
import java.nio.*;
import java.nio.channels.*;

class FileMapSchreiber {
    public static void main(String[] args) throws IOException {
	if (args.length < 1) {
	    System.out.println("Aufruf mittels java FileMapSchreiber [Datei]");
	    return;
	}
	File f = new File(args[0]).getCanonicalFile();
	FileChannel in = new RandomAccessFile(f, "rw").getChannel();
	long pos = 0, len = f.length();
	MappedByteBuffer buf = in.map(FileChannel.MapMode.READ_WRITE, pos, len);
	while (true) {
	    byte b = (byte) Math.round(256 * Math.random());
	    System.out.println("1. Byte: " + b);
	    buf.put(0, b);
	    // Die folgenden 3 Zeilen bewirken eine kurze Pause von 1 1/2 Sekunden (siehe Kap. 17):
	    try {
		Thread.currentThread().sleep(1500);
	    } catch (InterruptedException ex) {} // ignoriere.
	    
	}

    }
}
