// FileTest.java

import java.io.*;
import java.util.Date;

class FileTest {
    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.out.println("Starten mittels java FileTest "
			       + "<Datei/Verzeichnisname>");
            return;
        }
        File f = new File(args[0]).getCanonicalFile();
        if (!f.exists() || !f.canRead()) {
            System.out.println("Datei/Verzeichnis \"" + f + "\" nicht gefunden");
            return;
        }
        if (f.isDirectory()) {
            System.out.println("Inhalt von Verzeichnis \"" + f + "\":");
            File[] datei = f.listFiles();
            for (int i = 0; i < datei.length; i++)
		System.out.println(datei[i].getName());
        } else {
            System.out.println("Eigenschaften von Datei \"" + f + "\":");
	    System.out.println("lesbar: " + f.canRead());
	    System.out.println("schreibbar: " + f.canWrite());
	    System.out.println("Lnge: " + f.length() + " Bytes");
	    System.out.println("Letzte nderung: " + new Date(f.lastModified()));
        }
    }
}
