// KanalWortZaehler.java

import java.io.*;
import java.nio.*;
import java.nio.channels.*;
import java.nio.charset.*;

class KanalWortZaehler {
    static int PUFFER_GROESSE = 10000;
    public static void main(String[] args) {
	if (args.length < 1) {
	    System.out.println("Aufruf mittels java KanalWortZaehler "
			       + "<Dateiname>");
	    return;
	}
	long woerter = 0;
	try {
	    File f = new File(args[0]).getCanonicalFile();
	    if (! f.exists() || ! f.isFile() || ! f.canRead()) {
		System.out.println("Das kann ich nicht zhlen.");
		return;
	    }
	    FileChannel in = new FileInputStream(f).getChannel();
	    ByteBuffer buf = ByteBuffer.allocateDirect(PUFFER_GROESSE);
	    CharBuffer bufChar = CharBuffer.allocate(PUFFER_GROESSE);
	    char[] bufFeld = bufChar.array();
	    CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
	    decoder.onMalformedInput(CodingErrorAction.REPLACE);
	    CoderResult res;
	    boolean warInnerhalbWort, binInnerhalbWort = false;
	    boolean ende = false;
	    do {
		ende = (in.read(buf) == -1);
		buf.flip();
		boolean underflow = false, geleert = false;
		do {
		    if (! underflow)
			res = decoder.decode(buf, bufChar, ende);
		    else {
			res = decoder.flush(bufChar);
			geleert = true;
		    }
		    bufChar.flip();
		    int limit = bufChar.limit();
		    for (int i = 0; i < limit; i++) {
			warInnerhalbWort = binInnerhalbWort;
			binInnerhalbWort = Character.isLetter(bufFeld[i]);
			if (warInnerhalbWort && ! binInnerhalbWort)
			    woerter++;
		    }
		    bufChar.clear();
		    underflow = res.isUnderflow();
		} while ((! ende && ! underflow) || (ende && ! geleert));
		buf.compact();
	    } while (! ende);
	    in.close();
	} catch (IOException ex) {
	    System.out.println("Beim Lesen ist ein Fehler aufgetreten.");
	    ex.printStackTrace();
	} finally {
	    System.out.println("Anzahl Wrter: " + woerter);
	}
    }
}
