// NaivePruefsummenTest.java

import java.nio.*;

class NaivePruefsummenTest {
    public static void fuellen(ByteBuffer buf) {
	int anzahl = (int) Math.floor(1000 * Math.random());
	buf.limit(anzahl);
	while (buf.hasRemaining()) {
	    byte b = (byte) Math.floor(256 * Math.random());
	    buf.put(b);
	}
    }
    public static void main(String[] args) {
	ByteBuffer buf = ByteBuffer.allocate(1000);
	fuellen(buf);
	buf.flip();
	int pruefsumme = new NaivePruefsumme().aktualisiere(buf);
	System.out.println("Anzahl Bytes: " + buf.limit() 
			   + ", Prfsumme: " + pruefsumme);
    }
}
