// Pruefsumme.java

import java.nio.ByteBuffer;

class Pruefsumme {
    protected int pruefsumme = 0;
    public int aktualisiere(byte[] buf, int start, int laenge) {
	int end = start + laenge;
	for (int i = start; i < end; i++) 
	    pruefsumme = (((pruefsumme & 1) != 0 ? 0x8000 : 0)
			  + (pruefsumme >> 1) + buf[i]) & 0xffff;
	return pruefsumme;
    }
    public int aktualisiere(ByteBuffer buf) {
	if (buf.hasArray()) {
	    int pruefsumme = aktualisiere(buf.array(), buf.arrayOffset() 
					  + buf.position(), buf.remaining());
	    buf.position(buf.limit());
	    return pruefsumme;
	} else {
	    byte[] bufFeld = new byte[buf.remaining()];
	    buf.get(bufFeld);
	    return aktualisiere(bufFeld, 0, bufFeld.length);
	}
    }
}
