// PruefsummenTest.java

import java.nio.ByteBuffer;

class PruefsummenTest {
    public static void fuellen(byte[] buf, int start, int laenge) {
	int end = start + laenge;
	for (int i = start; i < end; i++)
	    buf[i] = (byte) Math.floor(256 * Math.random());
    }
    public static void fuellen(ByteBuffer buf) {
	int anzahl = (int) Math.floor(buf.remaining() * Math.random());
	if (buf.hasArray()) {
	    fuellen(buf.array(), buf.arrayOffset() + buf.position(), anzahl);
	    buf.position(buf.position() + anzahl);
	} else {
	    byte[] bufFeld = new byte[anzahl];
	    fuellen(bufFeld, 0, anzahl);
	    buf.put(bufFeld);
	}
    }
    public static void main(String[] args) {
	ByteBuffer buf = ByteBuffer.allocate(1000);
	fuellen(buf);
	buf.flip();
	int pruefsumme = new Pruefsumme().aktualisiere(buf);
	System.out.println("Anzahl Bytes: " + buf.limit()
			   + ", Prfsumme: " + pruefsumme);
    }
}
