// WortZaehler.java

import java.io.*;

class WortZaehler {
    public static void main(String[] args) {
	if (args.length < 1) {
	    System.out.println("Aufruf mittels java WortZaehler <Dateiname>");
	    return;
	}
	long woerter = 0;
	try {
	    File f = new File(args[0]).getCanonicalFile();
	    if (! f.exists() || ! f.isFile() || ! f.canRead()) {
		System.out.println("Das kann ich nicht zhlen.");
		return;
	    }
	    BufferedReader in = new BufferedReader(new FileReader(f));
	    int ch;
	    boolean warInnerhalbWort, binInnerhalbWort = false;
	    while ((ch = in.read()) != -1) {
		warInnerhalbWort = binInnerhalbWort;
		binInnerhalbWort = Character.isLetter((char)ch);
		if (warInnerhalbWort && ! binInnerhalbWort)
		    woerter++;
	    }
	    in.close();
	} catch (IOException ex) {
	    System.out.println("Beim Lesen ist ein Fehler aufgetreten.");
	    ex.printStackTrace();
	} finally {
	    System.out.println("Anzahl Wrter: " + woerter);
	}
    }
}
