// PersistPanel.java

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.*;

class PersistPanel extends JPanel {
    private static PersistPanel persPan;
    private static final int MAX_ANZ = 1000;
    private static File file = new File(System.getProperty("java.io.tmpdir"), "panel.dat");
    private int anz = 0;
    private int[][] punkte = new int[MAX_ANZ][2];
    PersistPanel() {
        setBackground(Color.yellow);
        setForeground(Color.green);
        addMouseListener();
        persPan = this;
    }
    void addMouseListener() {
        addMouseListener(new MouseAdapter() {
            public void mousePressed(MouseEvent e) {
                if (anz < MAX_ANZ)
                    punkte[anz][0] = e.getX();
                    punkte[anz++][1] = e.getY();
                    repaint();
            }
        });
    }
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        for (int i = 0; i < anz; i++) 
            g.fillOval(punkte[i][0] - 5, punkte[i][1] - 5, 10, 10);
    }
    public static void main(String[] args) {
        JFrame f = new JFrame("Persistentes Punkte-Panel");
        persPan = new PersistPanel();
        JPanel pan = new JPanel();
        final JButton read = new JButton("Lesen"), write = new JButton("Schreiben");
        final Container c = f.getContentPane();
        read.setEnabled(false);
        write.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                try {
                    ObjectOutputStream oos = 
                        new ObjectOutputStream(new FileOutputStream(file));
                    oos.writeObject(persPan);
                    oos.close();
                } catch(IOException ex) { 
                    ex.printStackTrace();
                }
                c.remove(persPan);
                c.validate();
                c.repaint();
                write.setEnabled(false);
                read.setEnabled(true);
            }
        });
        read.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                try {
                    ObjectInputStream ois = 
                        new ObjectInputStream(new FileInputStream(file));
                    persPan = (PersistPanel)ois.readObject();
                    ois.close();
                } catch(Exception ex) { 
                    ex.printStackTrace();
                }
                c.add(persPan);
                c.validate();
                c.repaint();
                read.setEnabled(false);
                write.setEnabled(true);
                persPan.addMouseListener();
            }
        });
        pan.add(write);
        pan.add(read);
        c.add(pan, BorderLayout.NORTH);        
        c.add(persPan, BorderLayout.CENTER);
        f.setSize(400, 300);
	f.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        f.setVisible(true);
    }
}
