// FileViewer.java

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.*;

class FileViewer extends JPanel {
    private JDesktopPane desk;
    FileViewer() {
        setLayout(new BorderLayout());
        Box sel = Box.createHorizontalBox();
        JButton but = new JButton(new ImageIcon(
                                    FileViewer.class.getResource("icons/open.gif")));
        sel.add(but); 
        add(sel, BorderLayout.NORTH);
        desk = new JDesktopPane();
        add(desk);
        but.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ev) {
                JFileChooser dialog = new JFileChooser();
                int auswahl = dialog.showOpenDialog(FileViewer.this);
                if (auswahl == JFileChooser.APPROVE_OPTION)
                    oeffne(dialog.getSelectedFile());
            }
        });
    }
    public void oeffne(File datei) {
        try {
            JInternalFrame fr = new JInternalFrame(datei.toString(), true, true, true, true); 
            JTextArea text = new JTextArea(10, 40);
            text.setLineWrap(true);
            text.read(new FileReader(datei), null);
            fr.getContentPane().add(new JScrollPane(text));
            fr.pack();
            fr.setVisible(true);
            desk.add(fr);
        } catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Datei " + datei + " nicht gefunden.");
        }
    }
    public static void main(String[] args) {
        JFrame f = new JFrame("File-Viewer");
        f.getContentPane().add(new FileViewer());
        f.setSize(500, 400);
	f.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        f.setVisible(true);
    }
}
