// PostenModel.java

import java.util.*;
import javax.swing.table.*;

class PostenModel extends AbstractTableModel {
    private List posten;
    PostenModel(List posten) {
        this.posten = posten;
    }
    public int getRowCount() {
        return posten.size();
    }
    public int getColumnCount() {
        return 3;
    }
    public Object getValueAt(int zeile, int spalte) {
        Posten post = (Posten)posten.get(zeile);
        if (spalte == 0)
            return post.artikel();
        else if (spalte == 1)
            return new Double(post.preis());
        else
            return new Boolean(post.bezahlt());
    }
    public String getColumnName(int spalte) {
        return (spalte == 0) ? "Artikel" : ((spalte == 1) ? "Preis" : "bezahlt?");
    }
    public Class getColumnClass(int spalte) {
        return (spalte == 0) ? String.class 
                             : ((spalte == 1) ? Double.class : Boolean.class);
    } 
}
