// Rechnung.java

import java.awt.*;
import java.text.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;

class Rechnung extends JPanel {
    private JTable table;
    private TableModel model;
    private JLabel summe = new JLabel();
    Rechnung(Object[][] posten, Object[] name) {
        setLayout(new BorderLayout());
        table = new JTable(posten, name);
        model = table.getModel();
        table.setPreferredScrollableViewportSize(new Dimension(300, 60));
        JPanel pan = new JPanel();
        pan.add(new JLabel("Summe: ", JLabel.RIGHT));
        berechneSumme();
        pan.add(summe);
        add(new JScrollPane(table), BorderLayout.CENTER);
        add(pan, BorderLayout.SOUTH);
        model.addTableModelListener(new TableModelListener() {
            public void tableChanged(TableModelEvent e) {
                berechneSumme();
            }
        });
    }
    void berechneSumme() {
        DecimalFormat form = new DecimalFormat("#,###.00 \u20ac");
        try {
            double sum = 0.0;
            for (int zeile = 0; zeile < model.getRowCount(); zeile++) 
                sum += Double.parseDouble((String)model.getValueAt(zeile, 1));
            summe.setText(form.format(sum));
        } catch (NumberFormatException ex) {
            summe.setText("Eingabefehler");
        }
    }
    public static void main(String[] args) {
        Object[] name = { "Artikel", "Preis" };
        Object[][] posten = { { "Mainboard", "199.80" }, 
			      { "Prozessor", "432.00" },
			      { "RAM", "1024.13" } };
        JFrame f = new JFrame("Rechnung");
        f.getContentPane().add(new Rechnung(posten, name));
        f.pack();
	f.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        f.setVisible(true);
    }
}
