// SimpleBrowser.java

import java.awt.*;
import java.io.*;
import javax.swing.*;
import javax.swing.event.*;

class SimpleBrowser extends JPanel {
    private JEditorPane inhalt;
    SimpleBrowser(String seite) {
        setLayout(new BorderLayout());
        inhalt = new JEditorPane();
        inhalt.setEditable(false);
        add(inhalt);
        inhalt.addHyperlinkListener(new HyperlinkListener() {
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED)
                    setPage(e.getURL().toString());
            }
        });
        setPage(seite);
    }
    void setPage(String seite) {
        try {
            inhalt.setPage(seite);
        } catch (IOException e) {
            inhalt.setText("Fehler beim Laden der Seite.");
        }
    }
    public static void main(String[] args) {
        String url = (args.length > 0) ? args[0] : "http://java.sun.com/";
        JFrame f = new JFrame("SimpleBrowser");
        f.getContentPane().add(new JScrollPane(new SimpleBrowser(url)));
        f.setSize(520, 500);
	f.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        f.setVisible(true);
    }
}
