// TableModifikation.java

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.*;
import javax.swing.table.*;

class TableModifikation extends JPanel {
    TableModifikation(Object[][] daten, Object[] name) {
        setLayout(new BorderLayout());
        final DefaultTableModel model = new DefaultTableModel(daten, name);
        final JTable table = new JTable(model);
        table.setPreferredScrollableViewportSize(new Dimension(550, 100));
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        add(new JScrollPane(table), BorderLayout.CENTER);
        JButton eBut = new JButton("Einfgen"), aBut = new JButton("Anzeigen");
        JPanel pan = new JPanel();
        pan.add(eBut);
        pan.add(aBut);
        eBut.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                int zeile = table.getSelectedRow();
                if (zeile > -1)
                    model.insertRow(zeile, new Object[] { });
            }
        });
        aBut.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < table.getRowCount(); i++) {
                    for (int j = 0; j < table.getColumnCount(); j++) 
                        System.out.print(table.getValueAt(i, j) + "\t");
                    System.out.println();
                }
                System.out.println();
            }
        });
        add(pan, BorderLayout.SOUTH);
    }
    public static void main(String[] args) {
        Object[] name = { "Name", "Erfindung", "geboren" };
        Object[][] daten =  {
            { "C. Babbage", "The Analytical Engine", new Integer(1792) },
            { "N. Chomsky", "Die Chomsky-Grammatiken", new Integer(1928) },
            { "G.W. Leibniz", "Das Dualsystem", new Integer(1646) },
            { "A.M. Turing", "Die Turing-Maschine", new Integer(1912) },
            { "K. Zuse", "Der 1. Relaisrechner Z1", new Integer(1910) }
        };
        JFrame f = new JFrame("Erweiterbare Tabelle");
        f.getContentPane().add(new TableModifikation(daten, name));
        f.pack();
	f.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        f.setVisible(true);
    }
}
