// TableSelect.java

import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;

class TableSelect extends JPanel  {
    TableSelect(Object[][] daten, Object[] name) {
        setLayout(new BorderLayout());
        final Icon[] icons = new Icon[daten.length];
        for (int i = 0; i < daten.length; i++)
            icons[i] = new ImageIcon(
                          TableSelect.class.getResource("icons/" + daten[i][0] + ".gif"));
        final Icon def = new ImageIcon(
                          TableSelect.class.getResource("icons/grey.gif"));
        final JTable table = new JTable(daten, name);
        table.setPreferredScrollableViewportSize(new Dimension(350, 60));
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        add(new JScrollPane(table), BorderLayout.CENTER);
        final JLabel bild = new JLabel(def);
        add(bild, BorderLayout.EAST);
        ListSelectionModel selectionModel = table.getSelectionModel();
        selectionModel.addListSelectionListener(new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent ev) {
                int zeile = table.getSelectedRow();
                if (zeile > -1) 
                    bild.setIcon(icons[zeile]);
                else
                    bild.setIcon(def);
            }
        });
    }
    public static void main(String[] args) {
        Object[] name = { "English", "Espa\u00f1ol", "Fran\u00e7ais", "Italiano" };
        Object[][] daten = { 
            { "red", "rojo", "rouge", "rosso" },
            { "green", "verde", "vert", "verde" },
            { "blue", "azul", "bleue", "azzurro" }
        };
        JFrame f = new JFrame("Tabelle mit Icon");
        f.getContentPane().add(new TableSelect(daten, name));
        f.pack();
	f.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        f.setVisible(true);
    }
}
