// PostenTest.java

import java.awt.*;
import java.text.*;
import java.util.*;
import javax.swing.*;
import javax.swing.table.*;

class PostenTest {
    public static void main(String[] args) {
        ArrayList posten = new ArrayList();
        posten.add(new Posten("Mainboard", 199.80, true));
        posten.add(new Posten("Prozessor", 432.00, false));
        posten.add(new Posten("RAM", 1024.13, true));
        TableModel model = new PostenModel(posten);
        JTable table = new JTable(model);
        table.setPreferredScrollableViewportSize(new Dimension(380, 70));
        table.setDefaultRenderer(Double.class, new TableCellRenderer() {
            DecimalFormat form = new DecimalFormat("#,###.00 \u20ac ");
            public Component getTableCellRendererComponent(JTable table, Object value, 
                    boolean isSelected, boolean hasFocus, int row, int column) {
                String str = form.format((Double)value);
                return new JLabel(str, JLabel.RIGHT);
            }
        });
        JFrame f = new JFrame("Rechnung");
        f.getContentPane().add(new JScrollPane(table));
        f.pack();
	f.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        f.setVisible(true);
    }
}
