// Anfrage.java

import java.io.*;
import java.net.*;

class Anfrage {
    private static void frage(String url, String name, String anfrage) 
            throws IOException {
        URL u = new URL(url);                 
        URLConnection uc = u.openConnection(); 
        uc.setDoOutput(true);
        Writer uout = new OutputStreamWriter(uc.getOutputStream());
        uout.write("Name=" + URLEncoder.encode(name, "ISO-8859-1") 
            + "&Anfrage=" + URLEncoder.encode(anfrage, "ISO-8859-1")); 
        uout.close();
        BufferedReader uin = 
            new BufferedReader(new InputStreamReader(uc.getInputStream()));
        String zeile;
        while ((zeile = uin.readLine()) != null)
            System.out.println(zeile);
    }
    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Starten mittels java Anfrage <URL>");
        } else
            try {
                BufferedReader in = 
                    new BufferedReader(new InputStreamReader(System.in));
                System.out.print("Anfrage> ");
                String anf; 
                while (!(anf = in.readLine()).equalsIgnoreCase("ende")) { 
                    if (anf.endsWith(" Erfindung")) {
                        int i = anf.lastIndexOf("Erfindung");
                        frage(args[0], anf.substring(0, i).trim(), "Erfindung");
                    } else if (anf.endsWith(" Daten")) {
                        int i = anf.lastIndexOf("Daten");
                        frage(args[0], anf.substring(0, i).trim(), "Daten");
                    } else 
                        System.out.println("Befehl unbekannt.\n"
					   + "<Person> Erfindung\n<Person> Daten");
                    System.out.print("Anfrage> ");
                }            
            } catch (IOException ex) {
                ex.printStackTrace();
            }
    }
}
