// DumpServer.java

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.*;

class DumpServer {
    protected WritableByteChannel out = Channels.newChannel(System.out);
    protected ByteBuffer buffer = ByteBuffer.allocateDirect(1000);
    protected int MAX_VERB = 100;

    DumpServer(int port) throws IOException {
	ServerSocketChannel server = ServerSocketChannel.open();
	server.socket().bind(new InetSocketAddress(port));
	System.out.println("Server wartet auf Port " + port + "");
	for (int i = 0; i < MAX_VERB; i++) {
	    SocketChannel sock = server.accept();
	    System.out.println("Verbindung zu " 
			       + sock.socket().getRemoteSocketAddress());
	    buffer.clear();
	    while (sock.read(buffer) != -1) {
		buffer.flip();
		while (buffer.hasRemaining())
		    out.write(buffer);
		buffer.clear();
	    }
	    System.out.println("Verbindung getrennt");
	}
	server.close();
    }
    public static void main(String[] args) throws IOException {
        if (args.length == 1) 
            new DumpServer(Integer.parseInt(args[0]));
        else
            System.out.println("Starten mittels java DumpServer <portnr>");
    }
}
