// KarteiClient.java

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;
import javax.swing.*;
import java.nio.channels.*;

class KarteiClient extends JPanel {
    private SocketChannel sock;
    private BufferedReader in;
    private BufferedWriter out;
    private JTextArea inhalt;
    KarteiClient(String host, int port) throws IOException {
        sock = SocketChannel.open(new InetSocketAddress(host, port));
	out = new BufferedWriter(Channels.newWriter(sock, "ISO-8859-1"));
	in = new BufferedReader(Channels.newReader(sock, "ISO-8859-1"));
	if (in == null)
	    System.out.println("in is null");
	setLayout(new BorderLayout());
        add(inhalt = new JTextArea(8, 40), BorderLayout.CENTER);
        inhalt.setEditable(false);
        JComboBox auswahl = new JComboBox();
        out.write(KarteiVerbindung.LISTE); out.newLine(); out.flush();
        String karte;
        while (!(karte = in.readLine()).equals(KarteiVerbindung.ENDE))
            auswahl.addItem(karte);
        zeigeKarte((String)auswahl.getSelectedItem());
        auswahl.addItemListener(new ItemListener() {
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == ItemEvent.SELECTED)
                    try {
                        zeigeKarte((String)e.getItem());
                    } catch (IOException ign) { }
            }
        });
        add(auswahl, BorderLayout.NORTH);
    }
    private void zeigeKarte(String str) throws IOException {
        inhalt.setText("");
        out.write(KarteiVerbindung.ZEIGE + " " + str); out.newLine(); out.flush();
        String zeile;
        while (!(zeile = in.readLine()).equals(KarteiVerbindung.ENDE))
            inhalt.append(zeile + "\n");
    }
    public static void main(String[] args) throws IOException {
        if (args.length == 2) {
	    final KarteiClient karteiClient = new KarteiClient(args[0], 
						       Integer.parseInt(args[1]));
	    final JFrame f = new JFrame("Kartei-Client");
	    f.getContentPane().add(karteiClient);
	    f.pack();
	    f.setVisible(true);
	    f.addWindowListener(new WindowAdapter() {
		    public void windowClosing(WindowEvent e) {
			try {
			    karteiClient.sock.close();
			} catch (IOException ign) { }
			f.dispose();
		    }
		});
        } else 
            System.out.println("Starten mittels java KarteiClient "
			       + "<hostname> <portnr>");
    }
}
