// KarteiServerMultiplexed.java

import java.io.*;
import java.net.InetSocketAddress;
import java.nio.channels.*;
import java.util.Iterator;

class KarteiServerMultiplexed {
    KarteiServerMultiplexed(int port) throws IOException {
	ServerSocketChannel kanalServer = ServerSocketChannel.open();
	kanalServer.socket().bind(new InetSocketAddress(port));
	kanalServer.configureBlocking(false);
	System.out.println("KarteiServer wartet auf Port " + port);
	Selector auswaehler = Selector.open();
	kanalServer.register(auswaehler, SelectionKey.OP_ACCEPT);

	while (auswaehler.select() > 0) {
	    for (Iterator i = auswaehler.selectedKeys().iterator(); i.hasNext();) {
		SelectionKey schluessel = (SelectionKey) i.next();
		i.remove();
		if (schluessel.isAcceptable()) {
		    ServerSocketChannel kanal = 
                                         (ServerSocketChannel) schluessel.channel();
		    SocketChannel kanalVerbindung = kanal.accept();
		    kanalVerbindung.configureBlocking(false);
		    kanalVerbindung.register(auswaehler, SelectionKey.OP_READ, 
					     new KarteiVerbindung(kanalVerbindung));
		} else if (schluessel.isReadable()) {
		    KarteiVerbindung verbindung = 
                                         (KarteiVerbindung) schluessel.attachment();
		    verbindung.antworte();
		}
	    }
	}
	kanalServer.close();
    }
    public static void main(String[] args) throws IOException {
        if (args.length == 1) 
            new KarteiServerMultiplexed(Integer.parseInt(args[0]));
        else
            System.out.println("Starten mittels java KarteiServerMultiplexed "
			       + "<portnr>");
    }
}
