// KarteiServerMultithreaded.java

import java.io.*;
import java.net.InetSocketAddress;
import java.nio.channels.*;

class KarteiServerMultithreaded {
    protected final int MAX_VERB = 100;

    KarteiServerMultithreaded(int port) throws IOException {
	ServerSocketChannel kanalServer = ServerSocketChannel.open();
	kanalServer.socket().bind(new InetSocketAddress(port));
	System.out.println("KarteiServer wartet auf Port " + port);
	
	for (int i = 0; i < MAX_VERB; i++) {
	    SocketChannel kanalVerbindung = kanalServer.accept();
	    new Thread(new KarteiVerbindung(kanalVerbindung)).start();
	}
	kanalServer.close();
    }
    public static void main(String[] args) throws IOException {
        if (args.length == 1) 
            new KarteiServerMultithreaded(Integer.parseInt(args[0]));
        else
            System.out.println("Starten mittels java KarteiServerMultithreaded "
			       + "<portnr>");
    }
}
