// KarteiVerbindung.java

import java.io.*;
import java.nio.channels.*;

class KarteiVerbindung implements Runnable {
    static final String LISTE = "liste", ZEIGE = "zeige", ENDE = ".";
    SocketChannel sock;
    BufferedReader in;
    BufferedWriter out;

    KarteiVerbindung(SocketChannel sock) {
        this.sock = sock; 
	out = new BufferedWriter(Channels.newWriter(sock, "ISO-8859-1"));
	in = new BufferedReader(Channels.newReader(sock, "ISO-8859-1"));
	melde("neue Verbindung auf Port " + sock.socket().getPort());
    }
    public void run() {
	try {
	    while (antworte() != null)
		;
	} catch (IOException ex) {
	    ex.printStackTrace();
	}
    }
    public String antworte() throws IOException {
	String anfrage = null;
	try {
	    if ((anfrage = in.readLine()) != null) {
		if (anfrage.equalsIgnoreCase(LISTE)) {
		    String[] liste = new File("kartei").getCanonicalFile().list();
		    melde("sende Liste (" + liste.length + " Karten)");
		    for (int i = 0; i < liste.length; i++) {
			out.write(liste[i]); out.newLine();
		    }
		} else if (anfrage.startsWith(ZEIGE)) {
		    String karte = anfrage.substring(ZEIGE.length() + 1).trim();
		    melde("sende Karte " + karte);
		    File f = new File("kartei/" + karte).getCanonicalFile();
		    FileChannel fin = new FileInputStream(f).getChannel();
		    long len = f.length();
		    while ((len -= fin.transferTo(0, f.length(), sock)) > 0)
			;
		    fin.close();
		    out.newLine();
		}
		out.write(ENDE); out.newLine(); out.flush();
	    }
	} catch (IOException ex) {}
	if (anfrage == null) {
	    melde("Verbindung getrennt");
	    sock.close();
	}
	return anfrage;
    }
    private void melde(String meldung) {
        System.out.println("[" + sock.socket().getRemoteSocketAddress()
			   + ": " + meldung + "]");
    }
}
