// Mail.java

import java.io.*;
import java.net.*;

class Mail {
    public static void main(String[] args) {
        try {
            BufferedReader in = 
                new BufferedReader(new InputStreamReader(System.in));
            System.out.print("Von: ");
            String von = in.readLine();
            System.out.print("An: ");
            String an = in.readLine();
            System.out.print("Betr: ");
            String betr = in.readLine();
            URL u = new URL("mailto:" + an);
            URLConnection uc = u.openConnection();
            System.out.println("Verbindungsaufbau ...");
            uc.setDoInput(false);      // kein Input von diesem URL
            uc.setDoOutput(true);      // aber Output dorthin
            uc.connect();
            BufferedWriter ucout = new BufferedWriter(new OutputStreamWriter(uc.getOutputStream()));
            ucout.write("From: \"" + von + "\" <" 
			+ System.getProperty("user.name") + "@" 
			+ InetAddress.getLocalHost().getHostName() + ">\n"
			+ "To: " + an + "\n"
			+ "Subject: " + betr + "\n"
			+ "\n");
            System.out.println("Text eingeben. Mit einem einzelnen '.' terminieren");
            String str;
            while (((str = in.readLine()) != null) && (!str.equals(".")))
                ucout.write(str + "\n");
	    ucout.close();
            System.out.println("Nachricht versandt");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
