// MesswertClient.java

import java.io.IOException;
import java.net.*;
import java.util.Random;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;

class MesswertClient {
    MesswertClient(String hostname, int port) throws IOException {
	DatagramChannel kanal = DatagramChannel.open();
	ByteBuffer buffer = ByteBuffer.allocateDirect(100);
	SocketAddress zieladresse = new InetSocketAddress(hostname, port);
	while (true) {
	    double wert = Messwert.wert();          
	    buffer.clear(); 
	    buffer.putDouble(wert).flip();
	    int n = kanal.send(buffer, zieladresse);
	}
    }
    public static void main(String[] args) throws IOException {
        if (args.length == 2) 
            new MesswertClient(args[0], Integer.parseInt(args[1]));
        else
            System.out.println("Starten mittels java MesswertClient "
			       + "<hostname> <portnr>");
    }
    private static class Messwert {
        static final int SLEEP_SEK = 500 + (int)(Math.random()*4000), 
            MITTELWERT = (int)(Math.random()*100);
        static Random gen = new Random();
        static double wert() {
	    try {
		Thread.sleep(SLEEP_SEK);
	    } catch (InterruptedException ign) { }
            return 5*gen.nextGaussian() + MITTELWERT; 
        }
    }
}
