// MesswertServer.java
    
import java.io.IOException;
import java.net.*;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;

class MesswertServer {
    MesswertServer(int port) throws IOException {
	DatagramChannel kanal = DatagramChannel.open();
	kanal.socket().bind(new InetSocketAddress("localhost", port));
	ByteBuffer buffer = ByteBuffer.allocateDirect(1000);
	HashMap tab = new HashMap();
	DecimalFormat form = new DecimalFormat("##.###");
	System.out.println("Warte auf port " + kanal.socket().getLocalPort());
	while (true) {
	    buffer.clear();
	    SocketAddress sender = kanal.receive(buffer);
	    buffer.flip();
	    double wert = buffer.getDouble();
	    int nr;
	    if (tab.get(sender) != null)
		nr = ((Integer)tab.get(sender)).intValue();
	    else {
		nr = tab.size();
		tab.put(sender, new Integer(nr));
	    }
	    for (int i = 0; i < nr; i++)
		System.out.print("\t");
	    System.out.println(form.format(wert));
	}
    }
    public static void main(String args[]) throws IOException {
        if (args.length == 1)
            new MesswertServer(Integer.parseInt(args[0])); 
        else
            System.out.println("Starten mittels java MesswertServer <port>");
    }
}
