// URIParser.java

import java.io.*;
import java.net.*;

class URIParser {
    public static void main(String[] args) {
        BufferedReader in = 
            new BufferedReader(new InputStreamReader(System.in));
        System.out.print("URI: ");
        try {
            String urlString;
            while (! (urlString = in.readLine()).equalsIgnoreCase("ende")) { 
                try {
                    URI uri = new URI(urlString);
                    System.out.println("Schema   : " + uri.getScheme()
				       + "\nSchemaspezifischer Teil: "
				       + uri.getSchemeSpecificPart()
				       + "\nFragment : " + uri.getFragment());
		    if (! uri.isOpaque()) 
			System.out.println("Autoritt: " + uri.getAuthority()
					   + "\nPfad     : " + uri.getPath()
					   + "\nAnfrage  : " + uri.getQuery()
					   + "\nUser     : " + uri.getUserInfo()
					   + "\nHost     : " + uri.getHost()
					   + "\nPort     : " + uri.getPort());
                } catch (URISyntaxException e) {
                    System.out.println("URI nicht korrekt gebildet.");
                }
                System.out.print("\nURI: ");
            }
        } catch (IOException ign) { }
    }
}
