// AnfrageServlet.java

import java.io.*;
import java.util.HashMap;
import javax.servlet.*;
import javax.servlet.http.*;

public class AnfrageServlet extends HttpServlet { 
    private static class Person {
        String name, erfindung, daten;
        Person(String name, String erfindung, String daten) {
            this.name = name; 
            this.erfindung = erfindung; 
            this.daten = daten;
        }
    }
    private static Person[] tab = {
        new Person("C. Babbage", "The Analytical Engine", "1792 - 1871"),
        new Person("N. Chomsky", "Die Chomsky-Grammatiken", "* 1928"),
        new Person("J. Gosling", "Die Programmiersprache Java", "n.a."),
        new Person("G.W. Leibniz", "Das Dualsystem", "1646 - 1716"),
        new Person("A.M. Turing", "Die Turing-Maschine", "1912 - 1954"),
        new Person("K. Zuse", "Der 1. Relaisrechner Z1", "1910 - 1995")
    };
    private static String NAME = "Name", ANFRAGE = "Anfrage", 
        ERFINDUNG = "Erfindung", DATEN = "Daten";

    private HashMap map;
    public void init(ServletConfig config) {
	map = new HashMap();
	for (int i = 0;i < tab.length; i++)
	    map.put(tab[i].name, tab[i]);
    }
    public void doPost(HttpServletRequest req, HttpServletResponse res)
            throws ServletException, IOException {
        String[] namen = req.getParameterValues(NAME),
            anfragen = req.getParameterValues(ANFRAGE);
        String name = namen[0], frage = anfragen[0];
	Person person = (Person) map.get(name);

        res.setContentType("text/html");
	PrintWriter rout = res.getWriter();
	rout.print("<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>\n"
		   + "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\"\n"
		   + "  \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">\n"
		   + "<html xmlns=\"http://www.w3.org/1999/xhtml\">\n"
		   + "<head>\n" 
		   + "  <title> Personenangaben </title>\n" 
		   + "</head>\n" 
		   + "<body>\n" 
		   + "<h1>Personenangaben</h1>\n<p>"); 
	if (person == null)
	    rout.print("Person " + name + " nicht in der Datenbank gefunden.");     
	else if (frage.equals(DATEN)) 
	    rout.print("Daten von " + name + ": " + person.daten);
	else if (frage.equals(ERFINDUNG)) 
	    rout.print("Erfindung von " + name + ": " + person.erfindung);
	rout.println("</p>\n</body>\n</html>");
    }
}
