// TCPIPClientApplet.java

import java.awt.*;
import java.awt.event.*;
import java.io.IOException;
import java.net.*;
import javax.swing.*;
import java.nio.*;
import java.nio.channels.*;
import java.nio.charset.Charset;

public class TCPIPClientApplet extends JApplet {
    protected JTextField host, port, frage, status;
    protected JTextArea res;
    private SocketChannel sock;
    protected Charset charset = Charset.forName("ISO-8859-1");
    protected ByteBuffer buffer = ByteBuffer.allocateDirect(1000);
    protected Thread leser;
    public void init() {
        Container c = getContentPane();
        Box box = Box.createHorizontalBox();
        box.add(new JLabel("Host", JLabel.RIGHT));
        box.add(host = new JTextField(15));
        box.add(new JLabel("Port", JLabel.RIGHT));
        box.add(port = new JTextField(15));
        box.add(new JLabel("Anfrage", JLabel.RIGHT));
        box.add(frage = new JTextField(15));
        c.add(box, BorderLayout.NORTH);
        res = new JTextArea(); 
        c.add(new JScrollPane(res), BorderLayout.CENTER);
        Box box2 = Box.createHorizontalBox();
        box2.add(new JLabel("Status", JLabel.RIGHT));
        box2.add(status = new JTextField(50));
        c.add(box2, BorderLayout.SOUTH);
        frage.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
		res.setText("");
                String zeile = frage.getText();
                try {
                    if (!zeile.startsWith("ende")) {
			status.setText("Senden...\n");
			sock.write(charset.encode(CharBuffer.wrap(zeile + "\n")));
		    } else {
			leser.interrupt();
                        sock.close();
                        status.setText("Verbindung getrennt");
                    }
                } catch (IOException ioe) {
                    status.setText(ioe.toString());
                }
            }
        });
        port.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
		status.setText("Verbinden...\n");
                String hostname = host.getText();
                try {
                    int portnr = Integer.parseInt(port.getText());
		    sock = SocketChannel.open(new InetSocketAddress(hostname, portnr));
                    status.setText("Client gebunden an lokalen Port: " + sock.socket().getLocalPort());
		    leser.start();
                } catch (UnknownHostException ux) {
                    status.setText(hostname + " ist dem DNS nicht bekannt.");
                } catch (IOException ioe) {
                    status.setText(ioe.toString());
                }
            }
        });
	leser = new Thread(new Runnable() {
		public void run() {
		    try {
			while (sock.read(buffer) != -1) {
			    buffer.flip();
			    res.append(charset.decode(buffer).toString());
			    buffer.clear();
			}
		    } catch (ClosedByInterruptException ex) { // ignoriere: Benutzereingabe "ende" 
		    } catch (IOException ex) {
			status.setText("Fehler beim Lesen der Serverantwort: " + ex.toString());
		    }
		}
	    });
	leser.setDaemon(true);
    }
}
