// NCApplet.java
        
import java.awt.*;
import java.awt.event.*;
import java.rmi.*;
import javax.swing.*;
import java.io.*;
        
public class NCApplet extends JApplet { 
    private Server serv;
    private NachrichtenEmpfaenger empfaenger;
    private String mitteilung, name = "Anonymous";
    private Runnable updater;
    public void init() {
        final JTextArea meldungen = new JTextArea(20, 70);
	final JTextField eingabe = new JTextField(70);
        Container c = getContentPane();
        c.add(new JScrollPane(meldungen), BorderLayout.CENTER);
        c.add(eingabe, BorderLayout.SOUTH);
        meldungen.setEditable(false);
        updater= new Runnable() {
            public void run() {
                meldungen.append(mitteilung + "\n");
            }
        };
        try {
	    String server = "rmi://" + getCodeBase().getHost()
		            + "/nachrichtenServer";
	    meldungen.append("Verbinde mit " + server + "...");
	    serv = (Server)Naming.lookup(server);
            empfaenger = new NachrichtenEmpfaenger(this);
            serv.addClient(empfaenger);
        } catch (Exception ign) { 
	    StringWriter out = new StringWriter();
	    PrintWriter pout = new PrintWriter(out);
	    ign.printStackTrace(pout);
	    pout.close();
	    meldungen.append(out.toString());
	}
        eingabe.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                try {
                    mitteilung = eingabe.getText();
                    serv.notifyClients(name, mitteilung);
                    eingabe.setText("");
                } catch (Exception ign) { 
		    meldungen.append(ign.toString());
		}
            }
        });
	meldungen.append(" - ok\n");
    }
    public void destroy() {
        try {
            serv.removeClient(empfaenger);
        } catch (Exception ign) { }
    }
    public void update(String str) {
        mitteilung = str;
        try {
            SwingUtilities.invokeLater(updater);
        } catch (Exception ign) { }
    }
}
