// NachrichtenClient.java
    
import java.io.*;
import java.rmi.*;
import java.rmi.server.*;
    
class NachrichtenClient extends UnicastRemoteObject implements Client {
    public NachrichtenClient(String name, String server) throws Exception {
        Server serv = (Server)Naming.lookup(server);
        serv.addClient(this);
        BufferedReader in = 
            new BufferedReader(new InputStreamReader(System.in));
        String text;
        System.out.print("> ");
        while (!(text = in.readLine()).equals("ende"))
            serv.notifyClients(name, text);
        serv.removeClient(this);
    }
    public void update(String str) throws RemoteException {
        System.out.println("\r" + str);
        System.out.print("> ");
    }
    public static void main(String[] args) {
        if (System.getSecurityManager() == null)
            System.setSecurityManager(new RMISecurityManager());
        try {
            if (args.length > 0) {
		String server = (args.length > 1 ? args[1]
				 : "rmi://134.155.57.121:1099/nachrichtenServer");
                new NachrichtenClient(args[0], server);
	    } else
                System.out.println("Starten mittels java NachrichtenClient "
				   + "<Benutzername> [<Server>]");
        } catch (Exception e) { e.printStackTrace(); }
    }
}
