// NachrichtenServer.java
    
import java.rmi.*;
import java.rmi.server.*;
import java.util.*;
    
class NachrichtenServer extends UnicastRemoteObject implements Server {
    private Collection clients;
    public NachrichtenServer() throws RemoteException {
        clients = new HashSet();
    }
    public synchronized void addClient(Client c) throws RemoteException {
        System.out.println("Anmeldung");
        clients.add(c);
    }
    public synchronized void removeClient(Client c) throws RemoteException {
       System.out.println("Abmeldung");
       clients.remove(c);
    }
    public void notifyClients(String name, String mitteilung) 
                                                    throws RemoteException {
        System.out.println("Mitteilung");
        Object[] locSet = setKop();
        for (int i = locSet.length - 1; i >= 0; i--) {
            Client c = (Client)locSet[i];
            try {
                c.update(name + ": " + mitteilung);
            } catch (RemoteException e) {
                removeClient(c);
            }
        }
    }
    private synchronized Object[] setKop() {
        return clients.toArray();
    }
    public static void main(String[] args) {
        try {
            NachrichtenServer serv = new NachrichtenServer();
            Naming.rebind("nachrichtenServer", serv);
            System.out.println("Nachrichtenserver bereit.");
        } catch (Exception e) { e.printStackTrace(); }
    }
}
