// AppletViewer.java

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

class AppletViewer extends JFrame {
    AppletViewer(final JApplet applet, int width, int height) {
        JMenuBar mbar = new JMenuBar();
        JMenu menu = new JMenu("applet");
        final String[] aktion = { "start", "stop", "destroy" };
        ActionListener lis  = new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand() == aktion[0])
                    applet.start();
                else if (e.getActionCommand() == aktion[1])
                    applet.stop();
                else if (e.getActionCommand() == aktion[2])
                    applet.destroy();
            }
        };
        for (int i = 0; i < aktion.length; i++) {
            JMenuItem mitem = new JMenuItem(aktion[i]);
            mitem.addActionListener(lis);
            menu.add(mitem);
        }
        mbar.add(menu);
        Container c = getContentPane();
	c.add(mbar, BorderLayout.SOUTH);
        applet.init();
        c.add(applet, BorderLayout.CENTER);
        setSize(width, height);
        setVisible(true);
        applet.start();
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                applet.stop();
                applet.destroy();
		dispose();
		System.exit(0);
            }
        });
	pack();
	setVisible(true);
    }
    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            System.out.println("Starten mittels java AppletViewer <Klassenname> <Breite> <Hhe>");
            return;
        }
        Class c = Class.forName(args[0]);
	new AppletViewer((JApplet)c.newInstance(), Integer.parseInt(args[1]), Integer.parseInt(args[2]));
    }
}
