// ListColorTest.java

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

class ListColorTest extends JPanel {
    ListColorTest() {
        setLayout(new BorderLayout());
        JButton but1 = new JButton("Vordergrundfarbe auswhlen"),
            but2 = new JButton("Hintergrundfarbe auswhlen");
        add(but1, BorderLayout.NORTH);
        add(but2, BorderLayout.SOUTH);
        String[] os =  { 
            "HP-UX", "JavaOS", "Linux", "MacOS", "MVS", 
            "OS390", "Solaris", "Win 98", "Win NT" 
        };
        final JList list = new JList(os);
        add(list, BorderLayout.CENTER);
        setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        but1.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Color col = JColorChooser.showDialog(ListColorTest.this,
                    "Bitte Vordergrundfarbe auswhlen", Color.white);
                list.setForeground(col);
            }
        });
        but2.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Color col = JColorChooser.showDialog(ListColorTest.this,
                    "Bitte Hintergrundfarbe auswhlen", Color.white);
                list.setBackground(col);
            }
        });

    }
    public static void main(String[] args) {
        JFrame f = new JFrame("List-Color-Test");
        f.getContentPane().add(new ListColorTest());
        f.pack();
        f.setVisible(true);
    }
}
