// PultGUI.java

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

class PultGUI extends JPanel {
    private Getriebe getr;
    private JTextField t;
    private Container c;
    private JButton[] buts = {
        new JButton("Ausschalten"),
        new JButton("Hochschalten"),
        new JButton("Herunterschalten"),
        new JButton("Leerlauf")
    };
    private Methode[] aktion = {
        new Methode() { public void fuehreAus() { } }, 
        new Methode() { public void fuehreAus() { getr.hoch(); } }, 
        new Methode() { public void fuehreAus() { getr.herunter(); } }, 
        new Methode() { public void fuehreAus() { getr.leerlauf(); } }
    };
    PultGUI(Getriebe getr) {
        this.getr = getr;
        setLayout(new GridLayout(2, 1));
        JPanel p = new JPanel(), q = new JPanel();
        for (int i = 0; i < buts.length; i++) {
            p.add(buts[i]);
            buts[i].addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    schalte((JButton)e.getSource());
                }
            });
        }
        add(p);
        q.add(new JLabel("Gang:", Label.RIGHT));
        q.add(t = new JTextField("Leerlauf"));
        t.setEditable(false);
        add(q);
        setBackground(Color.yellow);
        p.setOpaque(false);
        q.setOpaque(false);
    }
    void update() {
        int aktg = getr.gang();
        if (aktg > 0)
            t.setText(String.valueOf(aktg));
        else
            t.setText("Leerlauf");
    }
    void schalte(JButton b) {
        for (int i = 0; i < buts.length; i++)
            if (b == buts[i]) {
                if (i == 0) {
                    c.removeAll();
                    c.validate();
                    c.repaint();
                } else {
                    aktion[i].fuehreAus();
                    update();
                }
                break;                   
            }
    }
    public static void main(String[] args) {
        JFrame f = new JFrame("Pult & Getriebe");
	f.getContentPane().add(new PultGUI(new Getriebe()));
	f.pack();
	f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	f.setVisible(true);
    }        
    class Hoch implements Methode {
        public void fuehreAus() { getr.hoch(); }
    }
    class Herunter implements Methode {
        public void fuehreAus() { getr.herunter(); }
    }
    class Leerlauf implements Methode {
        public void fuehreAus() { getr.leerlauf(); }
    }
    class Aus implements Methode {
        public void fuehreAus() { }
    }
    interface Methode {
        void fuehreAus();
    }
}
