// OverlayTest.java

import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;

class OverlayTest extends JComponent {
    OverlayTest(final JList list) {
        setLayout(new OverlayLayout(this));
        DefaultListModel model = (DefaultListModel)list.getModel();
        final JLabel[] icons = new JLabel[model.size()];
        for (int i = 0; i < icons.length; i++) {
            icons[i] = new JLabel(new ImageIcon((String)model.get(i)));
            icons[i].setOpaque(false);
            icons[i].setVisible(false);
            add(icons[i]);
        }
        list.addListSelectionListener(new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e) {
                for (int i = 0; i < icons.length; i++)
                    icons[i].setVisible(list.isSelectedIndex(i)); 
            }
        });
    }
    public static void main(String[] args) {
        String[] n = {
            "bluerose.gif", "redballs.gif", "greenribbon.gif"
        };
        DefaultListModel model;
        JList l = new JList(model = new DefaultListModel());
        for (int i = 0; i < n.length; i++)
            model.add(model.size(), n[i]);
        JFrame f = new JFrame("Overlay-Test");
        Container c = f.getContentPane();
        c.add(l, BorderLayout.WEST);
        c.add(new OverlayTest(l), BorderLayout.CENTER);
        f.pack();
        f.setVisible(true);
    }
}
