// KomponentenPopup.java

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

class KomponentenPopup {
    protected static void erzeugeMenuItem(JComponent c, String text, String icon, ActionListener lis) {
	JMenuItem it = new JMenuItem(text, new ImageIcon(KomponentenPopup.class.getResource("icons/" + icon)));
	c.add(it);
	it.addActionListener(lis);
    }
    public static void main(String[] args) {
        final JFrame f = new JFrame("Komponenten-Popup");
        JTextArea text = new JTextArea(13, 30);
	text.setOpaque(false);
        JLabel label = new JLabel("Hier knnen Sie Text eingeben:");
        JPopupMenu farben = new JPopupMenu("Hintergrundfarbe");
        ActionListener lis = new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("rot"))
                    f.getContentPane().setBackground(Color.red);
		else if (e.getActionCommand().equals("grn"))
                    f.getContentPane().setBackground(Color.green);
                else 
                    f.getContentPane().setBackground(Color.blue);
                }
        };
	erzeugeMenuItem(farben, "rot", "red.gif", lis);
	erzeugeMenuItem(farben, "blau", "blue.gif", lis);
	erzeugeMenuItem(farben, "grn", "green.gif", lis);

        MouseListener pop = new PopupListener(farben);
        Container c = f.getContentPane();
        c.add(label, BorderLayout.NORTH);
        c.add(text);
        f.pack();
	f.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        f.setVisible(true);

        c.addMouseListener(pop);
        text.addMouseListener(pop);
        label.addMouseListener(pop);
    }
}
