// PopupListener.java

import java.awt.event.*;
import javax.swing.*;

class PopupListener extends MouseAdapter {
    private JPopupMenu menu;
    PopupListener(JPopupMenu menu) {
        this.menu = menu;
    }
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) 
            menu.show(e.getComponent(), e.getX(), e.getY());
    }
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) 
            menu.show(e.getComponent(), e.getX(), e.getY());
    }
}
